<?php
 
include_once 'conexao.php';
 
class ModeloVaga  
{      
	static public function mdlAddVaga($dados){
    
		$stmt = Conexao::conectar()->prepare("INSERT INTO vaga 
						(vaga,preco, idioma, quantHorasFormacao, tipoCertificacao, idRecrutador, dataCadastro,oQueOsAlunosVaoAprenderNoCurso,alunoAlvo,requisitoParaCurso,capa,descricao,tipoVaga,descricaoCurta,modeloDeAulas,privacidade) 
						VALUES (:Vaga,:preco,:idioma,:quantHorasFormacao, :tipoCertificacao, :idRecrutador, :dataCadastro,:oQueOsAlunosVaoAprenderNoCurso,:alunoAlvo,:requisitoParaCurso,:capa,:descricao,:tipoVaga,:descricaoCurta,:modeloDeAulas,:privacidade)");
		$stmt->bindParam(":oQueOsAlunosVaoAprenderNoCurso", $dados["oQueOsAlunosVaoAprenderNoCurso"], PDO::PARAM_STR);
		$stmt->bindParam(":preco", $dados["preco"], PDO::PARAM_STR);
		$stmt->bindParam(":idioma", $dados["idioma"], PDO::PARAM_STR);
		$stmt->bindParam(":quantHorasFormacao", $dados["quantHorasFormacao"], PDO::PARAM_STR);
		$stmt->bindParam(":tipoCertificacao", $dados["tipoCertificacao"], PDO::PARAM_STR);
		$stmt->bindParam(":alunoAlvo", $dados["alunoAlvo"], PDO::PARAM_STR);
		$stmt->bindParam(":descricaoCurta", $dados["descricaoCurta"], PDO::PARAM_STR);
		$stmt->bindParam(":requisitoParaCurso", $dados["requisitoParaCurso"], PDO::PARAM_STR);
		$stmt->bindParam(":Vaga", $dados["Vaga"], PDO::PARAM_STR);
		$stmt->bindParam(":dataCadastro", $dados["dataCadastro"], PDO::PARAM_STR);
		$stmt->bindParam(":idRecrutador", $dados["idUsuario"], PDO::PARAM_STR);
		$stmt->bindParam(":capa", $dados["capa"], PDO::PARAM_STR);
		$stmt->bindParam(":descricao", $dados["descricao"], PDO::PARAM_STR);
		$stmt->bindParam(":tipoVaga", $dados["tipoVaga"], PDO::PARAM_STR);
		$stmt->bindParam(":modeloDeAulas", $dados["modeloDeAulas"], PDO::PARAM_STR);
		$stmt->bindParam(":privacidade", $dados["privacidade"], PDO::PARAM_STR);
		
		if($stmt->execute()){
			return "ok";
		}else{
			return "error";
		}

	}
 
	static public function mdlMostrarVagaPoridVaga($idVaga) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM vaga where idVaga = :idVaga");
			$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarVagasDisponivel() {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM vaga where idVaga > 0 and (privacidade = :p or privacidade = :p2)");
			$privacidade = "Publico";
			$privacidade1 = "";
			$stmt->bindParam(":p", $privacidade, PDO::PARAM_STR);
			$stmt->bindParam(":p2", $privacidade1, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}
  
	static public function mdlMostrarVagaPeloNomeDaVagaEPeloIdUsurario($vaga, $idRecrutador) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM vaga where vaga = :vaga and idRecrutador = :idRecrutador");
			$stmt->bindParam(":vaga", $vaga, PDO::PARAM_STR);
			$stmt->bindParam(":idRecrutador", $idRecrutador, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}
 
	static public function mdlMostrarMinhasVagasPorIdUsurario($idRecrutador) {

		$resultado = array(); 
			# Preparar a intrução para o Like IdOrganizacao:
			$idProfessorParaOSql = "%:$idRecrutador";
			$stmt = Conexao::conectar()->prepare("SELECT * FROM vaga where idRecrutador Like :idRecrutador or idRecrutador = :idUnicoDoRecrutador");
			$stmt->bindParam(":idRecrutador", $idProfessorParaOSql, PDO::PARAM_STR);
			$stmt->bindParam(":idUnicoDoRecrutador", $idRecrutador, PDO::PARAM_STR);
			$stmt ->execute();
			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarMinhasCursosDaOrganizacaoPorIdOrganizacao($idOrganizacao) {

			$resultado = array(); 
			# Preparar a intrução para o Like IdOrganizacao:
			$idOrganizacaoParaOSql = "$idOrganizacao:%";
			$stmt = Conexao::conectar()->prepare("SELECT * FROM vaga where idRecrutador Like :idRecrutador or idRecrutador = :idUnicoDoRecrutador");
			$stmt->bindParam(":idRecrutador", $idOrganizacaoParaOSql, PDO::PARAM_STR);
			$stmt->bindParam(":idUnicoDoRecrutador", $idOrganizacao, PDO::PARAM_STR);
			$stmt ->execute();
			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarCursosComPrecosEntreMinEMax($precoMin, $precoMax) {

		$resultado = array(); 
		$privacidade = "Publico";
		$privacidade1 = "";
	
		// Preparar a instrução SQL para selecionar cursos com preços entre precoMin e precoMax e com privacidade "Publico"
		$stmt = Conexao::conectar()->prepare("SELECT * FROM vaga WHERE preco BETWEEN :precoMin AND :precoMax AND (privacidade = :privacidade or privacidade = :privacidade1)");
		
		// Associar os parâmetros de preço mínimo, máximo e privacidade
		$stmt->bindParam(":precoMin", $precoMin, PDO::PARAM_INT);
		$stmt->bindParam(":precoMax", $precoMax, PDO::PARAM_INT);
		$stmt->bindParam(":privacidade", $privacidade, PDO::PARAM_STR);
		$stmt->bindParam(":privacidade1", $privacidade1, PDO::PARAM_STR);
		
		// Executar a consulta
		$stmt->execute();
		
		// Obter os resultados da consulta
		$resultado = $stmt->fetchAll(PDO::FETCH_ASSOC);
		
		// Retornar os resultados
		return $resultado;
	}
	
	
	static public function mdlMostrarVagasPorCategoriaDaVaga($tipoVaga) {

		$resultado = array(); 

		$stmt = Conexao::conectar()->prepare("SELECT * FROM vaga where tipoVaga = :tipoVaga and (privacidade = :p or privacidade = :p2)");
			$privacidade = "Publico";
			$privacidade1 = "";
			$stmt->bindParam(":p", $privacidade, PDO::PARAM_STR);
			$stmt->bindParam(":p2", $privacidade1, PDO::PARAM_STR);
			$stmt->bindParam(":tipoVaga", $tipoVaga, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarVagasPorNome($nome) {

		$resultado = array(); 

		$stmt = Conexao::conectar()->prepare("SELECT * FROM vaga where vaga = :nome and (privacidade = :p or privacidade = :p2)");
		$privacidade = "Publico";
		$privacidade1 = "";
		$stmt->bindParam(":p", $privacidade, PDO::PARAM_STR);
		$stmt->bindParam(":p2", $privacidade1, PDO::PARAM_STR);
		$stmt->bindParam(":nome", $nome, PDO::PARAM_STR);
		$stmt ->execute();

		$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;

	}

 
	static public function mdlMostrarVagasPorCategoriaDaVagaComLimite($tipoVaga, $limite) {
		$resultado = array(); 
		$stmt = null; // Use null em vez de uma string vazia para inicializar a variável
	
		if ($limite == "" || $limite == 0) {
			$stmt = Conexao::conectar()->prepare("SELECT * FROM vaga WHERE tipoVaga = :tipoVaga AND (privacidade = :p OR privacidade = :p2)");
		} else {
			$stmt = Conexao::conectar()->prepare("SELECT * FROM vaga WHERE tipoVaga = :tipoVaga AND (privacidade = :p OR privacidade = :p2) LIMIT :li");
			$stmt->bindParam(":li", $limite, PDO::PARAM_INT); // Use PDO::PARAM_INT para valores inteiros
		}
		
		$privacidade = "Publico";
		$privacidade1 = "";
		
		$stmt->bindParam(":p", $privacidade, PDO::PARAM_STR);
		$stmt->bindParam(":p2", $privacidade1, PDO::PARAM_STR);
		$stmt->bindParam(":tipoVaga", $tipoVaga, PDO::PARAM_STR);
		$stmt->execute();
	
		$resultado = $stmt->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;
	}
	

	static public function mdlMostrarUltimasVagasComLimite($limite) {
		$resultado = array(); 
		$stmt = null; // Use null em vez de uma string vazia para inicializar a variável
		$privacidade = "Publico";
		$privacidade1 = "";
	
		if ($limite == "" || $limite == 0) {
			$stmt = Conexao::conectar()->prepare("SELECT * FROM vaga WHERE privacidade = :p OR privacidade = :p2 ORDER BY idVaga DESC");
		} else {
			$stmt = Conexao::conectar()->prepare("SELECT * FROM vaga WHERE privacidade = :p OR privacidade = :p2 ORDER BY idVaga DESC LIMIT :li");
			$stmt->bindParam(":li", $limite, PDO::PARAM_INT); // Use PDO::PARAM_INT para valores inteiros
		}
	
		$stmt->bindParam(":p", $privacidade, PDO::PARAM_STR);
		$stmt->bindParam(":p2", $privacidade1, PDO::PARAM_STR);
		$stmt->execute();
	
		$resultado = $stmt->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;
	}
	

	static public function mdlMostrarUltimasVagasPorCategoriaDaVagaComLimite($tipoVaga,$limite) {

		$resultado = array(); 
		$stmt = "";
		if ($limite=="" || $limite == 0) {
			$stmt = Conexao::conectar()->prepare("SELECT * FROM vaga where tipoVaga = :tipoVaga and (privacidade = :p or privacidade = :p2)  order by idVaga DESC");
		}else {
			$stmt = Conexao::conectar()->prepare("SELECT * FROM vaga where tipoVaga = :tipoVaga and (privacidade = :p or privacidade = :p2) LIMIT :li order by idVaga DESC");
		}
			$privacidade = "Publico";
			$privacidade1 = "";
			$stmt->bindParam(":p", $privacidade, PDO::PARAM_STR);
			$stmt->bindParam(":p2", $privacidade1, PDO::PARAM_STR);
			$stmt->bindParam(":li", $limite, PDO::PARAM_STR);
			$stmt->bindParam(":tipoVaga", $tipoVaga, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarUltimasVagasPorPrecoComLimite($preco,$limite) {

		$resultado = array(); 
		$stmt = "";
		if ($limite=="" || $limite == 0) {
			$stmt = Conexao::conectar()->prepare("SELECT * FROM vaga where preco = :preco and (privacidade = :p or privacidade = :p2) order by idVaga DESC");
		}else {
			$stmt = Conexao::conectar()->prepare("SELECT * FROM vaga where preco = :preco and (privacidade = :p or privacidade = :p2) LIMIT $limite order by idVaga DESC");
		}
			$privacidade = "Publico";
			$privacidade1 = "";
			$stmt->bindParam(":p", $privacidade, PDO::PARAM_STR);
			$stmt->bindParam(":p2", $privacidade1, PDO::PARAM_STR);
			$stmt->bindParam(":preco", $preco, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}
 

	static public function mdlMostrarVagasPorTipoDeAulaComLimite($modeloDeAulas, $limite) {
		$resultado = array(); 
		$stmt = null; // Use null em vez de uma string vazia para inicializar a variável
	
		if ($limite == "" || $limite == 0) {
			$stmt = Conexao::conectar()->prepare("SELECT * FROM vaga WHERE modeloDeAulas = :modeloDeAulas and (privacidade = :p or privacidade = :p2)");
		} else {
			$stmt = Conexao::conectar()->prepare("SELECT * FROM vaga WHERE modeloDeAulas = :modeloDeAulas and (privacidade = :p or privacidade = :p2) ORDER BY idVaga DESC LIMIT :limite");
			$stmt->bindParam(":limite", $limite, PDO::PARAM_INT); // Use PDO::PARAM_INT para valores inteiros
		}
		$privacidade = "Publico";
			$privacidade1 = "";
			$stmt->bindParam(":p", $privacidade, PDO::PARAM_STR);
			$stmt->bindParam(":p2", $privacidade1, PDO::PARAM_STR);
		$stmt->bindParam(":modeloDeAulas", $modeloDeAulas, PDO::PARAM_STR);
		$stmt->execute();
	
		$resultado = $stmt->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;
	}
	
	static public function mdlMostrarVagasPorPrecoComLimite($preco,$limite) {

		$resultado = array(); 
		$stmt = "";
		if ($limite=="" || $limite == 0) {
			$stmt = Conexao::conectar()->prepare("SELECT * FROM vaga where preco = :preco and (privacidade = :p or privacidade = :p2)");
		}else {
			$stmt = Conexao::conectar()->prepare("SELECT * FROM vaga where preco = :preco and (privacidade = :p or privacidade = :p2) LIMIT $limite");
		}
			$privacidade = "Publico";
			$privacidade1 = "";
			$stmt->bindParam(":p", $privacidade, PDO::PARAM_STR);
			$stmt->bindParam(":p2", $privacidade1, PDO::PARAM_STR);
			$stmt->bindParam(":preco", $preco, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}


	static public function mdlMostrarVagasComPrecoMaisBaratoComLimite($limite) {

		$resultado = array(); 
		$stmt = "";
		if ($limite=="" || $limite == 0) {
			$stmt = Conexao::conectar()->prepare("SELECT * FROM vaga where preco <= 20000 order by preco ASC");
		}else {
			$stmt = Conexao::conectar()->prepare("SELECT * FROM vaga where preco <= 20000 order by preco ASC LIMIT $limite");
		}
		
			$stmt ->execute(); 

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarVagasComPrecoMaisCarosComLimite($limite) {

		$resultado = array(); 
		$stmt = "";
		if ($limite=="" || $limite == 0) {
			$stmt = Conexao::conectar()->prepare("SELECT * FROM vaga where preco > 20000 order by preco ASC");
		}else {
			$stmt = Conexao::conectar()->prepare("SELECT * FROM vaga where preco > 20000 order by preco ASC LIMIT $limite");
		}
		
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarTodasVagas() {

		$resultado = array();
		
			$stmt = Conexao::conectar()->prepare("SELECT * FROM vaga where privacidade = :p or privacidade = :p2 ");
			$privacidade = "Publico";
			$privacidade1 = "";
			$stmt->bindParam(":p", $privacidade, PDO::PARAM_STR);
			$stmt->bindParam(":p2", $privacidade1, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlEditarPrecoDoCertificadoPorIdVaga($idVaga, $precoCertificado){
 
		$stmt = Conexao::conectar()->prepare("UPDATE vaga SET precoCertificado = :precoCertificado where idVaga = :id ");
		$stmt->bindParam(":id", $idVaga, PDO::PARAM_STR);
		$stmt->bindParam(":precoCertificado", $precoCertificado, PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok"; 
		}else{
			return "error";
		}

	} 

	static public function mdlEditarModeloDoCertificadoPorIdVaga($idVaga, $idModeloCertificado){
 
		$stmt = Conexao::conectar()->prepare("UPDATE vaga SET idModeloCertificado = :idModeloCertificado where idVaga = :id ");
		$stmt->bindParam(":id", $idVaga, PDO::PARAM_STR);
		$stmt->bindParam(":idModeloCertificado", $idModeloCertificado, PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok"; 
		}else{
			return "error";
		}
	}
 
	static public function mdlEditarCapaDoCurso($idVaga, $capa){
 
		$stmt = Conexao::conectar()->prepare("UPDATE vaga SET capa = :capa where idVaga = :id ");
		$stmt->bindParam(":id", $idVaga, PDO::PARAM_STR);
		$stmt->bindParam(":capa", $capa, PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok"; 
		}else{
			return "error";
		}
	}
 
	static public function mdlEditaDadosDaVagaPorIdVaga($idVaga, $vaga, $preco,$idioma,$quantHorasFormacao,$tipoCertificacao,$modeloDeAulas,$tipoVaga,$descricao,$descricaoCurta,$requisitoParaCurso,$alunoAlvo,$oQueOsAlunosVaoAprenderNoCurso,$privacidade){
 
		$stmt = Conexao::conectar()->prepare("UPDATE vaga SET vaga = :vaga, preco = :preco, idioma = :idioma, quantHorasFormacao = :quantHorasFormacao, tipoCertificacao = :tipoCertificacao,modeloDeAulas = :modeloDeAulas, tipoVaga = :tipoVaga, descricao = :descricao, descricaoCurta = :descricaoCurta, requisitoParaCurso = :requisitoParaCurso, alunoAlvo = :alunoAlvo, oQueOsAlunosVaoAprenderNoCurso = :oQueOsAlunosVaoAprenderNoCurso, privacidade = :privacidade where idVaga = :id ");
		$stmt->bindParam(":id", $idVaga, PDO::PARAM_STR); 
		$stmt->bindParam(":vaga", $vaga, PDO::PARAM_STR);
		$stmt->bindParam(":preco", $preco, PDO::PARAM_STR);
		$stmt->bindParam(":idioma", $idioma, PDO::PARAM_STR);
		$stmt->bindParam(":quantHorasFormacao", $quantHorasFormacao, PDO::PARAM_STR);
		$stmt->bindParam(":tipoCertificacao", $tipoCertificacao, PDO::PARAM_STR);
		$stmt->bindParam(":modeloDeAulas", $modeloDeAulas, PDO::PARAM_STR);
		$stmt->bindParam(":tipoVaga", $tipoVaga, PDO::PARAM_STR);
		$stmt->bindParam(":descricao", $descricao, PDO::PARAM_STR);
		$stmt->bindParam(":descricaoCurta", $descricaoCurta, PDO::PARAM_STR);
		$stmt->bindParam(":requisitoParaCurso", $requisitoParaCurso, PDO::PARAM_STR);
		$stmt->bindParam(":alunoAlvo", $alunoAlvo, PDO::PARAM_STR);
		$stmt->bindParam(":oQueOsAlunosVaoAprenderNoCurso", $oQueOsAlunosVaoAprenderNoCurso, PDO::PARAM_STR);
		$stmt->bindParam(":privacidade", $privacidade, PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok"; 
		}else{
			return "error";
		}
	}

	static public function mdlEditaDadosDaVagaDeUmaOrganizacaoPorIdVaga($idVaga, $vaga, $preco,$idioma,$quantHorasFormacao,$tipoCertificacao,$modeloDeAulas,$tipoVaga,$descricao,$descricaoCurta,$requisitoParaCurso,$alunoAlvo,$oQueOsAlunosVaoAprenderNoCurso,$privacidade,$idOrganizacaoEFormador){
 
		$stmt = Conexao::conectar()->prepare("UPDATE vaga SET vaga = :vaga, preco = :preco, idioma = :idioma, quantHorasFormacao = :quantHorasFormacao, tipoCertificacao = :tipoCertificacao,modeloDeAulas = :modeloDeAulas, tipoVaga = :tipoVaga, descricao = :descricao, descricaoCurta = :descricaoCurta, requisitoParaCurso = :requisitoParaCurso, alunoAlvo = :alunoAlvo, oQueOsAlunosVaoAprenderNoCurso = :oQueOsAlunosVaoAprenderNoCurso, privacidade = :privacidade, idRecrutador = :idOrganizacaoEFormador where idVaga = :id ");
		$stmt->bindParam(":id", $idVaga, PDO::PARAM_STR); 
		$stmt->bindParam(":vaga", $vaga, PDO::PARAM_STR);
		$stmt->bindParam(":preco", $preco, PDO::PARAM_STR);
		$stmt->bindParam(":idioma", $idioma, PDO::PARAM_STR);
		$stmt->bindParam(":quantHorasFormacao", $quantHorasFormacao, PDO::PARAM_STR);
		$stmt->bindParam(":tipoCertificacao", $tipoCertificacao, PDO::PARAM_STR);
		$stmt->bindParam(":modeloDeAulas", $modeloDeAulas, PDO::PARAM_STR);
		$stmt->bindParam(":tipoVaga", $tipoVaga, PDO::PARAM_STR);
		$stmt->bindParam(":descricao", $descricao, PDO::PARAM_STR);
		$stmt->bindParam(":descricaoCurta", $descricaoCurta, PDO::PARAM_STR);
		$stmt->bindParam(":requisitoParaCurso", $requisitoParaCurso, PDO::PARAM_STR);
		$stmt->bindParam(":alunoAlvo", $alunoAlvo, PDO::PARAM_STR);
		$stmt->bindParam(":oQueOsAlunosVaoAprenderNoCurso", $oQueOsAlunosVaoAprenderNoCurso, PDO::PARAM_STR);
		$stmt->bindParam(":privacidade", $privacidade, PDO::PARAM_STR);
		$stmt->bindParam(":idOrganizacaoEFormador", $idOrganizacaoEFormador, PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok"; 
		}else{
			return "error";
		}
	}

	static public function mdlEliminarLikeDoEventoPorIdLike($id, $idUsuario){
 
		$stmt = Conexao::conectar()->prepare("DELETE FROM eventolikes where idEvento = :id and idUsuario = :idUsuario");
		$stmt->bindParam(":id", $id, PDO::PARAM_STR);
		$stmt->bindParam(":idUsuario", $idUsuario, PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok"; 
		}else{
			return "error";
		}

	}

}



?>